<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Home_model extends CI_Model
{

    public function count_new_orders($type = '')
    {
        $res = $this->db->select('count(c.id) as counter');
        if ($this->ion_auth->is_delivery_boy()) {
            $user_id = $this->session->userdata('user_id');
            $this->db->where('c.delivery_boy_id', $user_id);
        }
        $res = $this->db->get('`consignments` c')->result_array();


        return $res[0]['counter'];
    }




    public function count_dashboard_orders($type = '')
    {
        $res = $this->db->select('count(o.id) as counter');
        if (!empty($type) && $type != 'api') {
            if ($this->ion_auth->is_delivery_boy()) {
                $user_id = $this->session->userdata('user_id');
                $this->db->join('order_items oi', 'oi.order_id=o.id', 'left');
                $this->db->where('oi.delivery_boy_id', $user_id);
            }
        }
        $res = $this->db->get('`orders` o')->result_array();

        return $res[0]['counter'];
    }

    public function count_orders_by_status($status)
    {
        $res = $this->db->select('count(id) as counter');
        $this->db->where('active_status', $status);
        $res = $this->db->get('`orders` o')->result_array();
        return $res[0]['counter'];
    }

    public function count_return_request_approved_orders()
    {
        $res = $this->db->select('count(oi.id) as counter');
        if ($this->ion_auth->is_delivery_boy()) {
            $user_id = $this->session->userdata('user_id');
            $this->db->where('oi.delivery_boy_id', $user_id);
        }
        $this->db->where('oi.active_status', 'return_request_approved');
        $res = $this->db->get('`order_items` oi')->result_array();
        return $res[0]['counter'];
    }

    public function count_new_users()
    {
        $res = $this->db->select('count(u.id) as counter')->join('users_groups ug', ' ug.`user_id` = u.`id` ')
            ->where('ug.group_id=2')
            ->get('`users u`')->result_array();
        return $res[0]['counter'];
    }

    public function count_delivery_boys()
    {
        $res = $this->db->select('count(u.id) as counter')->where('ug.group_id', '3')->join('users_groups ug', 'ug.user_id=u.id')
            ->get('`users` u')->result_array();
        return $res[0]['counter'];
    }

    public function count_products($seller_id = "")
    {
        $res = $this->db->select('count(id) as counter ');
        if (!empty($seller_id) && $seller_id != '') {
            $res->where('seller_id=' . $seller_id);
        }
        $count = $res->get('`products`')->result_array();
        return $count[0]['counter'];
    }

    public function count_products_stock_low_status($seller_id = "")
    {

        $count_res = $this->db->select(' COUNT( distinct(p.id)) as `total` ')->join('product_variants', 'product_variants.product_id = p.id')
            ->join("seller_data sd", "p.seller_id=sd.user_id ");
        $where = "p.stock_type is  NOT NULL";

        $count_res->where($where);
        $count_res->group_Start();

        $count_res->where('(CASE 
            WHEN p.low_stock_limit > 0 THEN p.stock <= p.low_stock_limit 
            ELSE p.stock <= sd.low_stock_limit 
        END)');
        $count_res->where('p.availability  =', '1');

        $count_res->or_where('(CASE 
            WHEN p.low_stock_limit > 0 THEN product_variants.stock <= p.low_stock_limit 
            ELSE product_variants.stock <= sd.low_stock_limit 
        END)');
        $count_res->where('product_variants.availability  =', '1');
        $count_res->group_End();
        if (!empty($seller_id) && $seller_id != '') {
            $count_res->where('p.seller_id  =', $seller_id);
        }
        $product_count = $count_res->get('products p')->result_array();
        return $product_count[0]['total'];
    }

    public function count_products_availability_status($seller_id = "")
    {
        $count_res = $this->db->select(' COUNT( distinct(p.id)) as `total` ')->join('product_variants', 'product_variants.product_id = p.id');
        $where = "p.stock_type is  NOT NULL";
        $count_res->where($where);
        $count_res->group_Start();
        $count_res->where('p.stock ', '0');
        $count_res->where('p.availability ', '0');
        $count_res->or_where('product_variants.stock ', '0');
        $count_res->where('product_variants.availability', '0');
        $count_res->group_End();
        if (!empty($seller_id) && $seller_id != '') {
            $count_res->where('p.seller_id  =', $seller_id);
        }
        $product_count = $count_res->get('products p')->result_array();

        return $product_count[0]['total'];
    }

    public function approved_seller()
    {

        $query_approved_seller = $this->db->select('*')->where('status', '1')->get('seller_data');

        $approved_seller = $query_approved_seller->result_array();

        return $approved_seller;
    }


    public function count_approved_seller()
    {

        $query_approved_seller = $this->db->select(' COUNT(u.id) as `total` ')->join('users_groups ug', ' ug.user_id = u.id ')->join('seller_data sd', ' sd.user_id = u.id ')->where('sd.status', '1');

        $count_approved_seller = $query_approved_seller->get('users u')->result_array();
        foreach ($count_approved_seller as $row) {
            $total = $row['total'];
        }
        $count_approved_seller = $total;
        return $count_approved_seller;
    }

    public function not_approved_seller()
    {

        $query_not_approved_seller = $this->db->select('*')->where('status', '2')->get('seller_data');

        $not_approved_seller = $query_not_approved_seller->result_array();

        return $not_approved_seller;
    }


    public function count_not_approved_seller()
    {

        $query_not_approved_seller = $this->db->select(' COUNT(u.id) as `total` ')->join('users_groups ug', ' ug.user_id = u.id ')->join('seller_data sd', ' sd.user_id = u.id ')->where('sd.status', '2');
        $offer_count = $query_not_approved_seller->get('users u')->result_array();
        foreach ($offer_count as $row) {
            $total = $row['total'];
        }
        $count_not_approved_seller = $total;

        return $count_not_approved_seller;
    }

    public function deactive_seller()
    {

        $query_deactive_seller = $this->db->select('*')->where('status', '0')->get('seller_data');

        $deactive_seller = $query_deactive_seller->result_array();

        return $deactive_seller;
    }


    public function count_deactive_seller()
    {

        $query_deactive_seller = $this->db->select('*')->where('status', '')->get('seller_data');

        $count_deactive_seller = $query_deactive_seller->num_rows();

        return $count_deactive_seller;
    }

    public function total_earnings($type = "admin")
    {
        $select = "";
        if ($type == "admin") {
            $select = "SUM(admin_commission_amount) as total ";
        }
        if ($type == "seller") {
            $select = "SUM(seller_commission_amount) as total ";
        }
        if ($type == "overall") {
            $select = "SUM(sub_total) as total ";
        }
        $count_res = $this->db->select($select);
        $where = "is_credited=1";
        $count_res->where($where);

        $product_count = $count_res->get('order_items')->result_array();
        return $product_count[0]['total'];
    }
}
